package net.zomis.minesweeper.events.player;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.events.Command;
/**
 * Called when a player is writing a command, before the execution of the command is done, giving plugins a chance to cancel this event
 *
 * <b>Implementing your own commands should be done using {@link PlayerCommandEvent} and the {@link Command} annotation</b>
 */
public class PlayerPreCommandEvent extends PlayerEvent implements CancellableEvent {
	private String command;
	private String[] parameters;
	
	public PlayerPreCommandEvent(MinesweeperPlayer player, String command, String[] parameters) {
		super(player);
		this.command = command;
		this.parameters = parameters;
	}

	public String getCommand() {
		return command;
	}

	public String[] getParameters() {
		return parameters;
	}
	public String getParameter(int i) {
		if (this.parameters.length > i) return this.parameters[i];
		return "";
	}
	public String getFullCommand() {
		return UtilZomisUtils.implode(" ", parameters);
	}
	
	// Cancelled implementation
	private boolean cancelled;
	public boolean isCancelled() {
		return this.cancelled;
	}
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}

}
