package net.zomis.minesweeper.events.player;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
/**
 * Called when a player is sending a chat message, giving plugins a chance to react on what the player writes, or cancel the message from the player.
 *
 */
public final class PlayerChatEvent extends PlayerEvent implements CancellableEvent {
	private final String message;
	private final MinesweeperGame game;
	public PlayerChatEvent(MinesweeperPlayer player, MinesweeperGame game, String message) {
		super(player);
		this.message = message;
		this.game = game;
	}
	
	public String getMessage() {
		return message;
	}
	public boolean isGameChat() {
		return this.getGame() != null;
	}
	
	@Override
	public String toString() {
		return "PlayerChatEvent: " + getPlayer() + " says " + getMessage() + " in game " + getGame();
	}
	
	// Cancelled implementation
	private boolean cancelled;
	public boolean isCancelled() {
		return this.cancelled;
	}
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}

	public MinesweeperGame getGame() {
		return game;
	}

}

