package net.zomis.minesweeper.api;

import java.io.File;
import java.util.Random;

import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.game.MinesweeperMap;

public abstract class MinesweeperPlugin {
	/**
	 * Get a Random object with a correct Random seed.
	 * @return The Random object associated with this plugin and the specified game.
	 */
	@Deprecated
	Random getRandomizer(MinesweeperMap map) {
		return this.helper.getRandomizer(this, map);
	}
	
	/**
	 * Register an {@link EventListener} with the event system.
	 * @param listener the listener to register
	 */
    @Deprecated
	protected final void registerListener(EventListener listener) {
		helper.registerListener(this, listener);
	}
	
	private PluginHelper helper;
	private boolean enabled;
	private MinesweeperServer server;
	@Deprecated
	private String fileName = null;
	private String description;

    @Deprecated
	public abstract void onEnable();
    @Deprecated
	public abstract void onDisable();
	
	public final boolean isEnabled() {
		return this.enabled;
	}

	public final void setDescription(String description) {
		this.description = description;
	}

	public final String getDescription() {
		return this.description;
	}
	
	public final String getSimpleName() {
		return this.getClass().getSimpleName();
	}

    @Deprecated
	public final void setEnabled(boolean enabled) {
		if (this.enabled == enabled) return;
		if (enabled) {
			this.onEnable();
			this.enabled = true;
		}
		else {
			this.onDisable();
			this.enabled = false;
		}
	}

	public final void initialize(MinesweeperServer server, PluginHelper helper) {
		if (this.helper != null || this.server != null) throw new IllegalArgumentException("Plugin has already been initialized.");
		this.server = server;
		this.helper = helper;
	}

	public final MinesweeperServer getServer() {
		return this.server;
	}

	@Deprecated
	public final void log(String log) {
		this.helper.log(this.getClass(), log);
	}

	@Deprecated
	public final String getFileName() {
		return fileName;
	}

	public abstract boolean canBeChosenBy(MinesweeperPlayer user);

}
