package net.zomis.minesweeper.api;

import java.util.HashMap;
import java.util.Map;

public class Metadata {

	private Map<Object, Object> metadatas;

	public Metadata() {
		this.metadatas = new HashMap<Object, Object>();
	}

	public void set(Object key, Object value) {
		this.metadatas.put(key, value);
	}

	public Object get(Object key) {
		if (!this.metadatas.containsKey(key)) return null;
		return this.metadatas.get(key);
	}

	public <E> E addClass(E instance) {
		this.metadatas.put(instance.getClass(), instance);
		return instance;
	}
	
	@SuppressWarnings("unchecked")
	public <E> E getClass(Class<E> clazz) {
		if (clazz == null) throw new IllegalArgumentException("Class cannot be null.");
		
		Object obj = this.metadatas.get(clazz);
		if (obj == null) return null;

        return (E) obj;
	}
}
