package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
/**
 * Fired when a single {@link MinesweeperField} has become activated, for whatever reason.<br> 
 * This differs from {@link PlayerMoveEvent} and {@link PlayerAfterMoveEvent} because one move can activate many fields.
 */
public class FieldActivatedEvent extends PlayerGameEvent {

	private final MinesweeperField field;
	private final MinesweeperMove cause;

	public FieldActivatedEvent(MinesweeperField field, MinesweeperMove cause) {
		super(field.getMap(), cause != null ? cause.getPlayer() : null);
		this.field = field;
		this.cause = cause;
	}
	public FieldActivatedEvent(MinesweeperField field, MinesweeperPlayingPlayer player) {
		super(field.getMap(), player);
		this.field = field;
		this.cause = null;
	}
	/**
	 * @return The field that triggered the event.
	 */
	public MinesweeperField getField() {
		return field;
	}
	/**
	 * @return The {@link MinesweeperMove} that caused the field to activate, or null if there is no {@link MinesweeperMove} associated with this event.
	 */
	public MinesweeperMove getCause() {
		return cause;
	}
	
	@Override
	public String toString() {
		return "FieldActivatedEvent: " + this.getField() + "caused by " + this.getCause();
	}

}
