package net.zomis.minesweeper.events.invites;

import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
/**
 * Performed during starting of game. After all other start-events. Before game is added to the database.
 * Last chance to cancel the game.
 * @author Zomis
 */
public class InviteGameStartingEvent extends BaseEvent implements CancellableEvent {
	private final Invite invite;
	private final MinesweeperGame game;
	
	public InviteGameStartingEvent(Invite invite, MinesweeperGame game) {
		this.invite = invite;
		this.game = game;
	}

	public Invite getInvite() {
		return invite;
	}
	public MinesweeperGame getGame() {
		return game;
	}	
	
	// Cancelled implementation
	private boolean cancelled;
	public boolean isCancelled() {
		return this.cancelled;
	}
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}
}