package net.zomis.minesweeper.api.ai;

import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.ai.AIHelper;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public abstract class MinesweeperAI {
    private final String name;

    @Deprecated
    private boolean hidden = false;

	public MinesweeperAI(String name) {
        this.name = name;
	}

    @Deprecated
	public final boolean isHidden() {
		return this.hidden;
	}
    @Deprecated
	protected final void hide() {
		this.hidden  = true;
	}

	/**
	 * The main AI method which determines how the AI will play
	 * 
	 * @return A new instance of {@link MinesweeperMove} to indicate which move the AI prefer to do.
	 * Check if your move is possible before making it with {@link MinesweeperMove}.isAllowed(), otherwise your AI will look stupid for trying to make an illegal move.
	 */
	public abstract MinesweeperMove play(MinesweeperPlayingPlayer player);
	
	/**
	 * @param invite The {@link net.zomis.minesweeper.api.Invite} object
	 * @return True if the AI agrees to play against the player specified
	 */
	public abstract boolean respondToInvite(Invite invite);

	/**
	 * @return True if the AI agrees to draw the game, false otherwise
	 */
	public abstract boolean agreeDraw(MinesweeperPlayingPlayer player);

	public String getName() {
		return this.name;
	}
}
