package net.zomis.minesweeper.classic;

import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameEndedEvent;
import net.zomis.minesweeper.game.MinesweeperField;

public class EndShowMines implements EventListener {
	@Event
	public void onGameEnd(GameEndedEvent event) {
		for (MinesweeperField mf : event.getMap().getIteration()) {
			if (mf.isClicked()) continue;
			if (!mf.isMine()) continue;
			
			mf.activate();
		}
	}
}
