package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.game.MinesweeperMap;

public class CustomEvent extends GameEvent implements CancellableEvent {
	private final String	eventName;
	private final Object[] parameters;
	private boolean cancelled = false;

	public CustomEvent(MinesweeperMap map, String eventName, Object... parameters) {
		super(map);
		this.eventName = eventName;
		this.parameters = parameters;
	}
	public String getEventName() {
		return eventName;
	}
	public Object[] getParameters() {
		return parameters;
	}
	@Override
	public boolean isCancelled() {
		return cancelled;
	}
	@Override
	public void setCancelled(boolean cancel) {
		this.cancelled = cancel;
	}
}
