package net.zomis.minesweeper.api;

import java.util.Random;

import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.game.MinesweeperMap;

public interface PluginHelper {
	/**
	 * Register an {@link EventListener} with the event system.
	 * @param plugin The plugin in control of the {@link EventListener}
	 * @param listener the listener to register
	 */
	void registerListener(MinesweeperPlugin plugin, EventListener listener);

	MinesweeperPlugin getPlugin(String pluginName);
	
	/**
	 * Get Random
	 * @return The Random object associated with this plugin and the specified game.
	 */
	@Deprecated
	Random getRandomizer(MinesweeperPlugin plugin, MinesweeperMap map);

	@Deprecated
	void log(Class<?> clazz, String log);
}
