package net.zomis.weapons.classic;

import java.util.ArrayList;
import java.util.Collection;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;

public class BombWeapon extends BaseWeapon {

	public static final int RANGE = 2;
	public static final int USE_COUNT = 1;

	protected int hasUsed = 0;
	
	public int getUseCount() {
		return this.hasUsed;
	}
	
	@Override
	public String getWeaponType() {
		return MinesweeperMove.STANDARD_BOMB;
	}

	@Override
	public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
		Collection<MinesweeperField> affected = this.getFieldsAffected(user, field);
		if (affected == null) return false;
		return affected.size() > 0;
	}

	protected MinesweeperField getMove(MinesweeperPlayingPlayer user, MinesweeperField field) {
		int xpos = UtilZomisUtils.ensureRange(RANGE, field.getX(), field.getMap().getFieldWidth() - RANGE - 1);
		int ypos = UtilZomisUtils.ensureRange(RANGE, field.getY(), field.getMap().getFieldHeight() - RANGE - 1);
		return field.getMap().getPosition(xpos, ypos);
	}
	
	@Override
	public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
		field = getMove(user, field);
		
		ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
		for (MinesweeperField mf : this.getFieldsWithinRange(field, BombWeapon.RANGE)) {
			if (!mf.isClicked()) result.add(mf);
		}
		
		return result;
	}

	@Override
	public boolean canUse(MinesweeperPlayingPlayer user) {
		if (user.hasMostScore()) 
			return false;
		return this.hasUsed < BombWeapon.USE_COUNT;
	}

	@Override
	public boolean useAt(MinesweeperMove moveInfo) {
		if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) return false;
		
//		moveInfo.getMovePosition()
		MinesweeperMove move = moveInfo.getPlayer().createMove(this, this.getMove(moveInfo.getPlayer(), moveInfo.getMovePosition()));
		for (MinesweeperField mf : this.getFieldsAffected(moveInfo.getPlayer(), move.getMovePosition())) {
			this.expanderOpen(mf, move);
		}
		this.hasUsed++;
		moveInfo.getMap().nextTurn();
		return true;
	}

	@Override
	public void resetUsage() {
		this.hasUsed = 0;
	}
	
	@Override
	public String toString() {
		return (this.hasUsed == 0 ? "Unused " : "USED ") + super.toString();
	}

}
