package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
/**
 * Called when a player's turn has ended in a game
 */
public class GameTurnChangeEvent extends GameEvent {

	private final MinesweeperPlayingPlayer previousPlayer;

	public GameTurnChangeEvent(MinesweeperMap game, MinesweeperPlayingPlayer previousPlayer) {
		super(game);
		this.previousPlayer = previousPlayer;
	}

	public MinesweeperPlayingPlayer getPreviousPlayer() {
		return previousPlayer;
	}

}
