package net.zomis.minesweeper.game;

import java.util.List;

import net.zomis.minesweeper.api.MinesweeperAI;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public interface MinesweeperPlayingPlayer {
	boolean proposeDraw();
	MinesweeperPlayer getPlayer();

	String getName();
	/**
	 * Server only: Returns the instance of MinesweeperGame this playing player is playing in.
	 * Try to avoid using this method as much as possible and use MinesweeperMap instead.
	 * 
	 * @return The {@link MinesweeperGame} for this player, or null if there is none.
	 */

	void giveWeapon(MinesweeperWeapon weapon);

	boolean canUseWeapon(String weaponType);

	MinesweeperWeapon getWeapon(String weaponType);

	int getScore();

	void changeScore(int change);

	MinesweeperWeapon hasWeapon(MinesweeperWeapon weapon);

	boolean isMyTurn();

	boolean hasMostScore();

	int getIndex();

	boolean isAI();

	MinesweeperAI getAI();
	
	boolean isEliminated();
	
	/**
	 * @return 1 for the winner, 2 for the runner-up, etc. or -1 if the result position is not decided yet.
	 */
	int getResultPosition();

	List<MinesweeperWeapon> getWeapons();

	List<MinesweeperMove> getMoves();

	void eliminate(int resultPosition);

	void eliminateLoss();

	void eliminateWin();

	MinesweeperMap getMap();
	
	void reset();
	
	MinesweeperMove createMove(String weaponType, MinesweeperField field);
	
	MinesweeperMove createMove(MinesweeperWeapon weapon, MinesweeperField field);
	
	MinesweeperMove createMove(String moveData);
}