package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.events.BaseEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
/**
 * Abstract class for all Game-related events
 *
 */
public abstract class GameEvent extends BaseEvent {
	private MinesweeperMap map;

	public GameEvent(MinesweeperMap game) {
		this.map = game;
	}
	public MinesweeperGame getGame() {
		if (this.map instanceof MinesweeperGame) return (MinesweeperGame) this.map;
		else return null;
	}
	public MinesweeperMap getMap() {
		return this.map;
	}
	@Override
	public String toString() {
		return String.format("%s: %s", this.getClass().getSimpleName(), this.getMap());
	}
}
