package net.zomis.minesweeper.api;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperGame;

public interface MinesweeperServer {
	/**
	 * Log something
	 * @param string What to log
	 */
	void log(String string);
	/**
	 * Sends a chat message to all online players
	 * @param message The message to send
	 */
	void broadcastChat(String message);
	void broadcastLobbyChat(String message);

	/**
	 * Get the metadata related to the server.
	 * @return A {@link Metadata} object for the server.
	 */
	Metadata getMetadata();
	/**
	 * Log something
	 * @param tag Tag that indicates where the log is sent from
	 * @param log What to log
	 */
	void log(String tag, String log);
	
	MinesweeperPlayer getPlayerByName(String name);
	MinesweeperGame createTestGame(String[] plugins, int players);
	MinesweeperGame createAITestGame(String[] plugins, String[] aiNames);
	List<MinesweeperPlayer> getOnlinePlayers();
	boolean hasDatabaseConnection();
	MinesweeperGame getGame(int parseInt);
	List<MinesweeperPlayer> getAIs();
	void threadDisableLogging(PlayerCommandEvent event);
	String getHostName();
	MinesweeperPlayer getServerPlayer();
	
	boolean isAIRatingsLocked();
//	ExecutorService getScheduleService();
	void getGameTagParameters(String tag, ServerSelectResult<Integer> callback);
	void informAdmin(Object... data);
	ScheduledExecutorService getExecutor();
	Class<? extends MinesweeperAI> getAI(String name);
}
