package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
/**
 * Abstract superclass for all events related to both a game and a player.
 */
public abstract class PlayerGameEvent extends GameEvent {
	private final MinesweeperPlayingPlayer playingPlayer;
	private final MinesweeperPlayer player;
	public PlayerGameEvent(MinesweeperMap game, MinesweeperPlayingPlayer player) {
		super(game);
		this.playingPlayer = player;
		this.player = player != null ? player.getPlayer() : null;
	}
	
	public PlayerGameEvent(MinesweeperGame game, MinesweeperPlayer player) {
		super(game);
		this.player = player;
		if (game != null) {
			this.playingPlayer = game.getPlayingPlayer(player);
		}
		else {
			this.playingPlayer = null;
		}
	}
	public MinesweeperPlayingPlayer getPlayingPlayer() {
		return this.playingPlayer;
	}
	public MinesweeperPlayer getPlayer() {
		return this.player;
	}
	@Override
	public String toString() {
		return String.format("%s: %s in map %s", this.getClass().getSimpleName(), this.getPlayingPlayer(), this.getMap());
	}
}
