package net.zomis.minesweeper.api;

import java.util.List;

import net.zomis.minesweeper.game.MinesweeperGame;

public interface Invite {

	boolean isDelay();
	boolean isRating();
	Boolean isDatabase();
	void cancel();

	Invite forceAdd(MinesweeperPlayer player);

	MinesweeperPlayer getHost();

	List<MinesweeperPlayer> getPlayers();

	int getWaitingCount();

	Invite setAIDelay(boolean useDelay);
	Invite setRating(boolean useRating);
	Invite setDatabase(boolean useDatabase);
	Invite setPublic(Boolean setPublic);

	MinesweeperGame startGame();
	
	List<MinesweeperPlugin> getPlugins();

	boolean sendInvite(String username);
	boolean sendInvite(MinesweeperPlayer user);
	Invite autostart();

}
