/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.api;

import java.io.File;
import java.util.Random;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperServer;
import net.zomis.minesweeper.api.PluginHelper;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.game.MinesweeperMap;

public abstract class MinesweeperPlugin {
    private PluginHelper helper;
    private boolean enabled;
    private MinesweeperServer server;
    private String fileName = null;
    private String description;

    @Deprecated
    Random getRandomizer(MinesweeperMap map) {
        return this.helper.getRandomizer(this, map);
    }

    protected final void registerListener(EventListener listener) {
        this.helper.registerListener(this, listener);
    }

    public abstract void onEnable();

    public abstract void onDisable();

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getFullName() {
        return this.getClass().getCanonicalName();
    }

    public final String getSimpleName() {
        return this.getClass().getSimpleName();
    }

    public final ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public final void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        if (enabled) {
            this.onEnable();
            this.enabled = true;
        } else {
            this.onDisable();
            this.enabled = false;
        }
    }

    public final void initialize(MinesweeperServer server, PluginHelper helper, File file) {
        if (this.helper != null || this.server != null) {
            throw new IllegalArgumentException("Plugin has already been initialized.");
        }
        this.server = server;
        if (file != null) {
            this.fileName = file.getName();
        }
        this.helper = helper;
    }

    public final MinesweeperServer getServer() {
        return this.server;
    }

    @Deprecated
    public final void log(String log) {
        this.helper.log(this.getClass(), log);
    }

    @Deprecated
    public final String getFileName() {
        return this.fileName;
    }

    public abstract boolean canBeChosenBy(MinesweeperPlayer var1);

    public String toString() {
        return super.toString();
    }
}

