/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.weapons.classic;

import java.util.ArrayList;
import java.util.Collection;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.BaseWeapon;

public class BombWeapon
extends BaseWeapon {
    public static final int RANGE = 2;
    public static final int USE_COUNT = 1;
    protected int hasUsed = 0;

    public int getUseCount() {
        return this.hasUsed;
    }

    @Override
    public String getWeaponType() {
        return "B";
    }

    @Override
    public boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field) {
        Collection<MinesweeperField> affected = this.getFieldsAffected(user, field);
        if (affected == null) {
            return false;
        }
        return affected.size() > 0;
    }

    protected MinesweeperField getMove(MinesweeperPlayingPlayer user, MinesweeperField field) {
        int xpos = UtilZomisUtils.ensureRange(2, field.getX(), field.getMap().getFieldWidth() - 2 - 1);
        int ypos = UtilZomisUtils.ensureRange(2, field.getY(), field.getMap().getFieldHeight() - 2 - 1);
        return field.getMap().getPosition(xpos, ypos);
    }

    @Override
    public Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field) {
        field = this.getMove(user, field);
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        for (MinesweeperField mf : this.getFieldsWithinRange(field, 2)) {
            if (mf.isClicked()) continue;
            result.add(mf);
        }
        return result;
    }

    @Override
    public boolean canUse(MinesweeperPlayingPlayer user) {
        if (user.hasMostScore()) {
            return false;
        }
        return this.hasUsed < 1;
    }

    @Override
    public boolean useAt(MinesweeperMove moveInfo) {
        if (!this.canUseAt(moveInfo.getPlayer(), moveInfo.getMovePosition())) {
            return false;
        }
        MinesweeperMove move = moveInfo.getPlayer().createMove(this, this.getMove(moveInfo.getPlayer(), moveInfo.getMovePosition()));
        for (MinesweeperField mf : this.getFieldsAffected(moveInfo.getPlayer(), move.getMovePosition())) {
            this.expanderOpen(mf, move);
        }
        ++this.hasUsed;
        moveInfo.getMap().nextTurn();
        return true;
    }

    @Override
    public void resetUsage() {
        this.hasUsed = 0;
    }

    @Override
    public String toString() {
        return (this.hasUsed == 0 ? "Unused " : "USED ") + super.toString();
    }
}

