/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game;

import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.game.MinesweeperGame;

public class GameTag {
    private final int gameId;
    private final String tag;
    private final Integer parameter;
    private final MinesweeperGame game;
    private final Integer tagger;
    private boolean showPublic = true;
    private final TagType tagtype;
    private final MinesweeperPlayer taggerPlayer;
    private boolean saved;

    public GameTag(TagType tagtype, int gameid, String tag, Integer parameter, Integer whoTagged) {
        if (tagtype == null) {
            throw new IllegalArgumentException("Tagtype may not be null");
        }
        this.gameId = gameid;
        this.game = Minesweeper.getServer() != null ? Minesweeper.getServer().getGame(gameid) : null;
        this.tag = tag;
        this.parameter = parameter;
        this.tagger = whoTagged;
        this.taggerPlayer = null;
        this.tagtype = tagtype;
    }

    public GameTag(TagType tagtype, MinesweeperGame game, String tag, Integer parameter, MinesweeperPlayer whoTagged) {
        if (tagtype == null) {
            throw new IllegalArgumentException("Tagtype may not be null");
        }
        this.gameId = game.getGameID();
        this.game = game;
        this.tag = tag;
        this.parameter = parameter;
        this.tagger = whoTagged == null ? null : Integer.valueOf(whoTagged.getUserId());
        this.taggerPlayer = whoTagged;
        this.tagtype = tagtype;
    }

    public GameTag(TagType tagtype, MinesweeperGame game, String tag, Integer parameter) {
        this(tagtype, game, tag, parameter, null);
    }

    public GameTag(TagType tagtype, MinesweeperGame game, String tag) {
        this(tagtype, game, tag, null);
    }

    public MinesweeperGame getGame() {
        return this.game == null ? Minesweeper.getServer().getGame(this.gameId) : this.game;
    }

    public int getGameId() {
        return this.gameId;
    }

    public String getTag() {
        return this.tag;
    }

    public Integer getParameter() {
        return this.parameter;
    }

    public MinesweeperPlayer getTagger() {
        return this.taggerPlayer;
    }

    public Integer getTaggerId() {
        return this.tagger;
    }

    public boolean isPublic() {
        return this.showPublic;
    }

    public GameTag setPublic(boolean showPublic) {
        this.showPublic = showPublic;
        return this;
    }

    public TagType getTagType() {
        return this.tagtype;
    }

    public String toString() {
        return this.gameId + " #" + this.tag + (this.parameter == null ? "" : "=" + this.parameter) + " by " + this.tagger;
    }

    public void saveComplete() {
        if (this.saved) {
            throw new IllegalStateException("Saved flag already set.");
        }
        this.saved = true;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public static enum TagType {
        SERVER("server"),
        BEFORE("before"),
        AFTER("after");

        private final String str;

        private TagType(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

