/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.api;

import net.zomis.minesweeper.api.AIHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public abstract class MinesweeperAI {
    private final MinesweeperPlayingPlayer player;
    private boolean hidden = false;
    private AIHelper helper;

    public void onWin() throws InterruptedException {
    }

    public void onLose() throws InterruptedException {
    }

    public MinesweeperAI(MinesweeperPlayingPlayer player) {
        if (player == null) {
            throw new NullPointerException("Cannot create a MinesweeperAI without a playing player specified.");
        }
        this.player = player;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    protected final void hide() {
        this.hidden = true;
    }

    public abstract MinesweeperMove play();

    public abstract boolean respondToInvite(Invite var1);

    public abstract boolean agreeDraw();

    public final MinesweeperPlayer getPlayer() {
        return this.player.getPlayer();
    }

    public final MinesweeperMap getMap() {
        return this.player.getMap();
    }

    public final MinesweeperPlayingPlayer getPlayingPlayer() {
        return this.player;
    }

    public final void init(AIHelper aiHelper) {
        if (this.helper != null) {
            throw new IllegalStateException("AI Helper is already set.");
        }
        this.helper = aiHelper;
    }

    public final void sendChatMessage(String message) {
        if (this.helper != null) {
            this.helper.sendMessage(this.getPlayingPlayer(), message);
        }
    }

    public final MinesweeperMove playAs(String aiName) {
        Class<? extends MinesweeperAI> aiClass = this.helper.getAI(aiName);
        if (aiClass == null) {
            return null;
        }
        MinesweeperAI ai = this.getMap().getMapFactory().ai(this.getPlayingPlayer(), aiClass);
        return ai.play();
    }

    public final MinesweeperMove playAs(Class<? extends MinesweeperAI> aiClass) {
        if (aiClass == null) {
            return null;
        }
        MinesweeperAI ai = this.getMap().getMapFactory().ai(this.getPlayingPlayer(), aiClass);
        return ai.play();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

