/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.events.game;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.game.GameEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public abstract class PlayerGameEvent
extends GameEvent {
    private final MinesweeperPlayingPlayer playingPlayer;
    private final MinesweeperPlayer player;

    public PlayerGameEvent(MinesweeperMap game, MinesweeperPlayingPlayer player) {
        super(game);
        this.playingPlayer = player;
        this.player = player != null ? player.getPlayer() : null;
    }

    public PlayerGameEvent(MinesweeperGame game, MinesweeperPlayer player) {
        super(game);
        this.player = player;
        this.playingPlayer = game != null ? game.getPlayingPlayer(player) : null;
    }

    public MinesweeperPlayingPlayer getPlayingPlayer() {
        return this.playingPlayer;
    }

    public MinesweeperPlayer getPlayer() {
        return this.player;
    }

    @Override
    public String toString() {
        return String.format("%s: %s in map %s", this.getClass().getSimpleName(), this.getPlayingPlayer(), this.getMap());
    }
}

