/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.api;

import net.zomis.minesweeper.api.FieldType;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class FieldInfo {
    public static final FieldInfo VISIBLE_MINE = new FieldInfo().setMine(true).setFieldType(FieldType.CLICKED);
    public static final FieldInfo BLOCKED = new FieldInfo().setFieldType(FieldType.BLOCKED);
    public static final FieldInfo UNCLICKED = new FieldInfo().setFieldType(FieldType.UNCLICKED);
    private int playerIndex = -1;
    private FieldType fieldType = null;
    private boolean mine = false;
    private int value = 0;
    private boolean highlight = false;

    public FieldInfo() {
    }

    public FieldInfo(MinesweeperField field) {
        this.playerIndex = field.getWhoClicked() == null ? -1 : field.getWhoClicked().getIndex();
        this.mine = field.isDiscoveredMine();
        this.value = field.getKnownValue();
        this.fieldType = field.getFieldStyle();
    }

    public FieldInfo(int value) {
        this.value = value;
        this.fieldType = FieldType.CLICKED;
    }

    public FieldInfo setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public FieldInfo setHighlight(boolean highlight) {
        this.highlight = highlight;
        return this;
    }

    public FieldInfo setMine(boolean isMine) {
        this.mine = isMine;
        return this;
    }

    public FieldInfo setPlayerIndex(int playerIndex) {
        this.playerIndex = playerIndex;
        return this;
    }

    public FieldInfo setPlayer(MinesweeperMap map, MinesweeperPlayingPlayer player) {
        this.playerIndex = player != null ? player.getIndex() : map.getPlayingPlayers().size();
        return this;
    }

    public FieldInfo setValue(int value) {
        this.value = value;
        return this;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public int getValue() {
        if (this.value < 0) {
            return 0;
        }
        return this.value;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public boolean isMine() {
        return this.mine;
    }

    public boolean hasPlayer() {
        return this.playerIndex >= 0;
    }
}

