/*
 * Decompiled with CFR 0.152.
 */
package net.zomis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;

public class UtilZomisList {
    private static Random random = new Random();

    public static <E> List<E> getAllExtreme(Iterable<E> all, double startValue, GetValueInterface<E> getValue) {
        ArrayList<E> result = new ArrayList<E>();
        double maxValue = startValue;
        for (E e : all) {
            double newValue = getValue.getValue(e);
            if (newValue > maxValue) {
                maxValue = newValue;
                result.clear();
                result.add(e);
                continue;
            }
            if (newValue != maxValue) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> E getRandom(List<E> list) {
        return UtilZomisList.getRandom(list, random);
    }

    public static <E> E getRandom(List<E> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        if (random == null) {
            random = UtilZomisList.random;
        }
        return list.get(random.nextInt(list.size()));
    }

    public static <E> E getRandom(E[] list) {
        return UtilZomisList.getRandom(list, random);
    }

    public static <E> E getRandom(E[] list, Random random) {
        if (list.length == 0) {
            return null;
        }
        if (random == null) {
            random = UtilZomisList.random;
        }
        return list[random.nextInt(list.length)];
    }

    public static <E> void filter(Collection<E> list, FilterInterface<E> filter) {
        Iterator<E> it = list.iterator();
        while (it.hasNext()) {
            E i = it.next();
            if (filter.shouldKeep(i)) continue;
            it.remove();
        }
    }

    public static <E> List<E> getAll(Iterable<E> list, FilterInterface<E> filter) {
        LinkedList<E> result = new LinkedList<E>();
        for (E e : list) {
            if (!filter.shouldKeep(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> boolean contains(Iterable<E> list, FilterInterface<E> filter) {
        return !UtilZomisList.getAll(list, filter).isEmpty();
    }

    public static <E> int getSize(Iterable<E> list, FilterInterface<E> filter) {
        return UtilZomisList.getAll(list, filter).size();
    }

    public static <E> void logArray(Iterable<E> list, LogInterface logFunction) {
        for (E e : list) {
            logFunction.log(e == null ? "null" : e.toString());
        }
    }

    public static <Element, Key> Map<Key, List<Element>> getMapFor(Iterable<Element> iterable, GetKeyInterface<Element, Key> getKeyInterface) {
        HashMap result = new HashMap();
        for (Element e : iterable) {
            List<Element> arrList;
            Key key = getKeyInterface.getKey(e);
            if (key == null) continue;
            if (!result.containsKey(key)) {
                arrList = new ArrayList<Element>();
                arrList.add(e);
                result.put(key, arrList);
                continue;
            }
            arrList = (List)result.get(key);
            arrList.add(e);
        }
        return result;
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map, final boolean descending) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int res = descending ? ((Comparable)e1.getValue()).compareTo(e2.getValue()) : ((Comparable)e2.getValue()).compareTo(e1.getValue());
                return res != 0 ? -res : 1;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static interface GetKeyInterface<Element, Key> {
        public Key getKey(Element var1);
    }

    public static interface LogInterface {
        public void log(String var1);
    }

    public static interface GetValueInterface<E> {
        public double getValue(E var1);
    }

    public static interface FilterInterface<E> {
        public boolean shouldKeep(E var1);
    }
}

