/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.events.player;

import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.CancellableEvent;
import net.zomis.minesweeper.events.player.PlayerEvent;
import net.zomis.minesweeper.game.MinesweeperGame;

public final class PlayerChatEvent
extends PlayerEvent
implements CancellableEvent {
    private final String message;
    private final MinesweeperGame game;
    private boolean cancelled;

    public PlayerChatEvent(MinesweeperPlayer player, MinesweeperGame game, String message) {
        super(player);
        this.message = message;
        this.game = game;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isGameChat() {
        return this.getGame() != null;
    }

    @Override
    public String toString() {
        return String.format("%s: %s says %s in game %s", this.getClass().getSimpleName(), this.getPlayer(), this.getMessage(), this.getGame());
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public MinesweeperGame getGame() {
        return this.game;
    }
}

