/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.weapons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class BaseWeapon
implements MinesweeperWeapon {
    @Override
    public abstract boolean canUse(MinesweeperPlayingPlayer var1);

    @Override
    public boolean canUseOn(MinesweeperPlayingPlayer user, MinesweeperPlayingPlayer target) {
        return false;
    }

    @Override
    public boolean use(MinesweeperPlayingPlayer user) {
        throw new RuntimeException("Illegal weapon use");
    }

    protected void recursiveAdd(Collection<MinesweeperField> collection, MinesweeperField field, RecursiveInterface recursiveCheck) {
        this.recursiveAdd(collection, field, recursiveCheck, new HashSet<MinesweeperField>());
    }

    private void recursiveAdd(Collection<MinesweeperField> collection, MinesweeperField field, RecursiveInterface recursiveCheck, Collection<MinesweeperField> recursiveChecked) {
        if (recursiveChecked.contains(field)) {
            return;
        }
        recursiveChecked.add(field);
        if (field == null) {
            return;
        }
        for (MinesweeperField mf : recursiveCheck.getRecursiveFields(field)) {
            if (mf == null) continue;
            if (recursiveCheck.performAdd(field, mf)) {
                collection.add(mf);
            }
            if (!recursiveCheck.performRecursive(field, mf)) continue;
            this.recursiveAdd(collection, mf, recursiveCheck, recursiveChecked);
        }
    }

    protected final void expanderOpen(MinesweeperField field, MinesweeperMove move) {
        field.activate(move);
        if (!field.isMine() && field.getValue() == 0) {
            for (MinesweeperField f : field.getNeighbors()) {
                if (f.isClicked()) continue;
                this.expanderOpen(f, move);
            }
        }
    }

    protected final Collection<MinesweeperField> getFieldsWithinRange(MinesweeperField field, int range) {
        ArrayList<MinesweeperField> result = new ArrayList<MinesweeperField>();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                MinesweeperField mf = field.getMap().getPosition(field.getX() + x, field.getY() + y);
                if (mf == null) continue;
                result.add(mf);
            }
        }
        return result;
    }

    @Override
    public boolean useOn(MinesweeperPlayingPlayer user, MinesweeperPlayingPlayer target) {
        return false;
    }

    @Override
    public abstract String getWeaponType();

    @Override
    public abstract boolean canUseAt(MinesweeperPlayingPlayer var1, MinesweeperField var2);

    @Override
    public abstract Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer var1, MinesweeperField var2);

    @Override
    public abstract boolean useAt(MinesweeperMove var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static interface RecursiveInterface {
        public boolean performAdd(MinesweeperField var1, MinesweeperField var2);

        public boolean performRecursive(MinesweeperField var1, MinesweeperField var2);

        public Collection<MinesweeperField> getRecursiveFields(MinesweeperField var1);
    }
}

