/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.game;

import net.zomis.minesweeper.game.MinesweeperMove;

public enum MoveAllowedState {
    NO_PLAYER("No player specified"),
    NO_WEAPON("No weapon specified"),
    NOT_PLAYER_TURN("It is not %player's turn"),
    WEAPON_NOT_FOUND("%player does not have %weapon weapon"),
    WEAPON_DENIED("%player cannot use %weapon (probably because of game situation or used too many times)"),
    WEAPON_POSITION_DENIED("%player is allowed to use %weapon, but not at the specified position"),
    DENIED_BY_PLUGIN("Move by %player was cancelled by plugin"),
    MOVE_FAILED("Move %move failed for unknown reasons"),
    OK("Move is allowed");

    private String message;

    private MoveAllowedState(String message) {
        this.message = message;
    }

    public String toString(MinesweeperMove move) {
        return this.message.replace("%player", move.getPlayer() == null ? "null" : move.getPlayer().getName()).replace("%pos", move.getMovePosition() == null ? "null" : move.getMovePosition().toString()).replace("%move", move == null ? "null" : move.toString()).replace("%weapon", move.getWeapon() == null ? "null" : move.getWeapon().toString());
    }

    public String toString() {
        return this.message;
    }

    public boolean isOK() {
        return this.equals((Object)OK);
    }
}

