/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.classic;

import java.util.List;
import net.zomis.minesweeper.events.Event;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.CustomEvent;
import net.zomis.minesweeper.events.game.PlayerAfterMoveEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class DefaultExpanderRule
implements EventListener {
    public static final String METADATA_KEY = "ExpanderRule";

    @Event
    public void onExpanderRule(PlayerAfterMoveEvent event) {
        if (event.getMap().getMinesCount() != event.getMap().getMinesLeft()) {
            return;
        }
        if (!event.getMove().getWeaponType().contentEquals("P")) {
            return;
        }
        for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
            if (pp.getName().contentEquals("#AI_Loser")) {
                return;
            }
            if (!pp.getName().contentEquals("AI_Loser")) continue;
            return;
        }
        if (event.getGame() != null && event.getGame().getMetadata().get(METADATA_KEY) != null) {
            return;
        }
        if (event.getMove().getMovePosition().getValue() == 0) {
            if (event.getMap().executeCustomEvent(new CustomEvent(event.getMap(), METADATA_KEY, new Object[0])).isCancelled()) {
                return;
            }
            List<MinesweeperField> unclicked = event.getMap().getAllUnclickedFields();
            for (MinesweeperField field : event.getMap().getIteration()) {
                if (unclicked.contains(field)) continue;
                field.inactivate();
                field.sendInfoToPlayers();
            }
            event.getMap().generate();
            if (event.getGame() != null) {
                event.getGame().sendChatMessage("#Server: Expander rule applied! (An open field was found before a mine. Recreated board)", 0xFF8000);
            } else {
                for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
                    if (pp.getPlayer() == null) continue;
                    pp.getPlayer().sendChat("#Server: Expander rule applied! (An open field was found before a mine. Recreated board)", 0xFF8000);
                }
            }
        }
        if (event.getMap().getCurrentPlayer().isAI()) {
            event.getMap().callAI();
        }
    }
}

