package net.zomis.minesweeper.weapons;

import java.util.Collection;

import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;



public interface MinesweeperWeapon {
	/**
	 * @return Unique identifier for this kind of weapon
	 */
	String getWeaponType();
	boolean canUse(MinesweeperPlayingPlayer user);
	boolean canUseAt(MinesweeperPlayingPlayer user, MinesweeperField field);
	Collection<MinesweeperField> getFieldsAffected(MinesweeperPlayingPlayer user, MinesweeperField field);
	boolean use(MinesweeperPlayingPlayer user);
	boolean useOn(MinesweeperPlayingPlayer user, MinesweeperPlayingPlayer target);
	boolean canUseOn(MinesweeperPlayingPlayer user, MinesweeperPlayingPlayer target);
	boolean useAt(MinesweeperMove moveInfo);
	
	/**
	 * Resets this weapon to make it as it were when it was just created.
	 */
	void resetUsage();
}
