/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.minesweeper.events.player;

import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.player.PlayerEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;

public class PlayerCommandEvent
extends PlayerEvent {
    public static final String PERMISSION_TESTER = "TESTER";
    public static final String PERMISSION_MODERATOR = "MODERATOR";
    public static final String PERMISSION_TRUSTED_USER = "TRUSTED";
    public static final String PERMISSION_ADMIN = "ADMIN";
    public static final String PERMISSION_DONATOR = "DONATOR";
    private final String command;
    private final String[] parameters;
    private boolean cancelled;

    public PlayerCommandEvent(MinesweeperPlayer player, String command) {
        super(player);
        if (!command.contains(" ")) {
            command = command + " ";
        }
        this.command = command.substring(0, command.indexOf(" "));
        command = command.substring(this.command.length() + 1);
        this.parameters = command.split(" ");
    }

    public PlayerCommandEvent(MinesweeperPlayer player, String command, String[] parameters) {
        super(player);
        this.command = command;
        this.parameters = parameters;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String getParameter(int i) {
        if (this.parameters.length > i) {
            return this.parameters[i];
        }
        return "";
    }

    public int getParameterInt(int i, int defaultValue) {
        try {
            return Integer.parseInt(this.getParameter(i));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getFullCommand() {
        return UtilZomisUtils.implode(" ", this.parameters);
    }

    public MinesweeperGame getGame() {
        if (this.getPlayer() == null) {
            return null;
        }
        return this.getPlayer().getGame();
    }

    public MinesweeperMap getMap() {
        if (this.getPlayer() == null) {
            return null;
        }
        return this.getPlayer().getMap();
    }

    @Override
    public String toString() {
        return String.format("%s: %s /%s %s", this.getClass().getSimpleName(), this.getPlayer(), this.getCommand(), this.getFullCommand());
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

