package net.zomis.minesweeper.aiscore;

import java.util.Map.Entry;

import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class SafeWithRiskAroundMineZomis extends AbstractScorer {
	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (data.getMineProbability() > 0) return 0;
		
		if (data.getProbabilities()[0] == 1.0) return 0; // Another scorer will take care of this situation

		if (data.getNeighbors().size() == 1) {
			Entry<FieldGroup<MinesweeperField>, Integer> theEntry = data.getNeighbors().entrySet().iterator().next();
			if (theEntry.getValue() == theEntry.getKey().size()) return -0.01;
		}
		
		if (!isInterestingField(field, data, scores.getWeapon())) return -2;
		
		double total = 0;
//		int numWithProb = 0;
		for (MinesweeperField neighbor : field.getNeighbors()) {
			if (neighbor.isClicked()) continue;
			
			ProbabilityKnowledge<MinesweeperField> neighborData = scores.getAnalyze().getKnowledgeFor(neighbor);
			if (neighborData == null) continue;
//			if (neighborData.getMineProbability() > 0) numWithProb++;
			
			
//			if (neighborData.getProbabilities()[0] > 0 && neighborData.getFieldsInGroup().size() > 8) // Only check open field group basically.
				total += neighborData.getMineProbability();
//			else total += 0.333;
		}
		
		return -total * 0.1; // * 0.1
	}

	// My turn and even number of moves: I will be the one who have to take a risk.
	
	public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, MinesweeperWeapon weapon) {
		return data.getProbabilities()[0] == 0 && data.getMineProbability() == 0;
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsClick(scores.getWeapon());
	}

}
