package net.zomis.plugin;

import java.util.Random;

import net.tejpbit.ais.AI_Challenger;
import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.GameStartEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

@Deprecated
public class MineprobChallenge extends MinesweeperPlugin implements EventListener {
	private double thinkProbability;
	private MineprobabilityAnalyze analyze;
	
	// @Event
	public void getMineProbabilityOfMove(PlayerMoveEvent event) {
		if (event.getPlayer().getGame() == null) return;
		
		double chosen = MineprobHelper.getMineProbabilityForField(event.getMove().getMovePosition());
		if (Math.abs(chosen - thinkProbability) <= 0.0001) {
			event.getGame().sendChatMessage("MineprobChallenge: Well done!");
			this.onChallengeStart(new GameStartEvent(event.getGame()));
			
			for (MinesweeperField field : event.getGame().getIteration()) field.sendInfoToPlayers(); // Update
		}
		else {
			this.gameSend(event.getGame(), "Sorry. I asked you to find a field with probability of\n" + this.thinkProbability + "\nbut you found one with\n" + chosen);
			event.getMove().getMovePosition().sendInfoToPlayers();
		}
		event.setCancelled(true);
		
	}
	
	// @Event
	public void onChallengeStart(GameStartEvent event) {
		this.createSomethingRandom(event.getGame());
		
		this.analyze = new MineprobabilityAnalyze(event.getGame());
		AnalyzeResult<MinesweeperField> solve = this.analyze.solve();
		FieldGroup<MinesweeperField> random = UtilZomisList.getRandom(solve.getGroups());
		this.thinkProbability = random.getProbability();
		gameSend(event.getGame(), "MineprobChallenge: I want you to click on a field with Mineprobability " + this.thinkProbability);
		event.getGame().sendChatMessage("MineprobChallenge: I want you to click on a field with Mineprobability " + this.thinkProbability);
	}
	
	private void gameSend(MinesweeperGame game, String string) {
		for (MinesweeperPlayer player : game.getPlayers()) {
			player.sendAlert(string);
		}
	}

	private void createSomethingRandom(MinesweeperGame game) {
		Random random = new Random();
		for (MinesweeperPlayingPlayer pp : game.getPlayingPlayers()) pp.changeScore(- pp.getScore());
		game.generate();
		int amount = random.nextInt(42) + 10;
		game.sendChatMessage("Making " + amount + " moves.");
		for (int i = 0; i < amount; i++) {
			if (game.getCurrentPlayer().getScore() >= 20) {
				game.sendChatMessage("Moves cancelled after " + i + " because of player score: " + game.getCurrentPlayer());
				break;
			}
			MinesweeperMove move;
			if (i <= amount - 10)
				move = new AI_Challenger().play(game.getCurrentPlayer());
			else move = new AI_Complexer().play(game.getCurrentPlayer());
			// #AI_Hard is too good at taking mines.
			if (move != null && move.getWeapon() != null)
				move.getWeapon().useAt(move);
			else game.sendChatMessage("Move could not be made: " + move);
		}
		game.setCurrentPlayerTurn(0);
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer player) {
		return player.hasPermission(PlayerCommandEvent.PERMISSION_ADMIN);
	}

	@Override
	public void onDisable() {
		
	}

	@Override
	public void onEnable() {
		if (this.getServer() == null) throw new NullPointerException("Server missing");
		
//		this.getServer().broadcastLobbyChat(this.getSimpleName() + " is inactivated.");
//		this.registerListener(this);
//		this.registerListener(new StandardNeighbors());
//		this.registerListener(new StandardWeapons());
	}

}
