package net.zomis.minesweeper.scores;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;



public class ScoreConfigFactory {
	private final AnalyzeMethod	analyzeMethod;
	private ScoreSet	scoreSet;
	private final List<PostScorer> postScorers;
	private final List<PreScorer> preScorers;

	public ScoreConfigFactory(AnalyzeMethod analyzeMethod) {
		this.analyzeMethod = analyzeMethod;
		this.scoreSet = new ScoreSet();
		this.postScorers = new LinkedList<PostScorer>();
		this.preScorers = new LinkedList<PreScorer>();
	}

	public ScoreConfigFactory withScorer(AbstractScorer scorer) {
		scoreSet.put(scorer, 1.0);
		return this;
	}
	public ScoreConfigFactory withScorer(AbstractScorer scorer, double weight) {
		scoreSet.put(scorer, weight);
		return this;
	}
	public ScoreConfigFactory multiplyAll(double value) {
		ScoreSet oldScoreSet = scoreSet;
		scoreSet = new ScoreSet();
		for (Map.Entry<AbstractScorer, Double> ee : oldScoreSet.entrySet()) {
			scoreSet.put(ee.getKey(), ee.getValue() * value);
		}

		return this;
	}

	public ScoreConfigFactory withPost(PostScorer post) {
		postScorers.add(post);
		return this;
	}

	public ScoreConfig build() {
		return new ScoreConfig(analyzeMethod, this.preScorers, this.postScorers, this.scoreSet);
	}

	public <E> ScoreConfigFactory withPreScorer(PreScorer analyzer) {
		this.preScorers.add(analyzer);
		return this;
	}
	
	
	
}
