package net.zomis.minesweeper.analyze.endgame;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.SortedSet;

import net.zomis.UtilZomisList;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;
import net.zomis.minesweeper.weapons.classic.BombWeapon;
import net.zomis.minesweeper.weapons.classic.ClickWeapon;

public class WinChanceAnalyze {
	private final Map<MinesweeperMove, WinChanceData> moves;
	private final MinesweeperPlayingPlayer	player;
	
	public MinesweeperMap getMap() {
		return this.player.getMap();
	}
	public WinChanceAnalyze(MinesweeperPlayingPlayer forPlayer) {
		this.moves = new HashMap<MinesweeperMove, WinChanceData>();
		this.player = forPlayer;
		
		this.analyze();
	}
	
	private void analyze() {
		List<MinesweeperMove> possibleMoves = this.calcPossibleMoves();
		AnalyzeProvider analyze = AnalyzeFactory.analyze(getMap(), true);
		for (MinesweeperMove move : possibleMoves) {
			this.moves.put(move, this.analyzeMove(move, analyze));
		}
	}
	
	private WinChanceData analyzeMove(MinesweeperMove move, AnalyzeProvider analyze) {
		WinChanceData data = new WinChanceData(move);
		if (move.getWeapon() instanceof BombWeapon) {
			data.analyzeBomb(analyze);
		}
		if (move.getWeapon() instanceof ClickWeapon) {
			data.analyzeClick(analyze);
		}
		return data;
	}
	private List<MinesweeperMove> calcPossibleMoves() {
		LinkedList<MinesweeperMove> list = new LinkedList<MinesweeperMove>();
		
		for (MinesweeperWeapon weap : player.getWeapons()) {
			if (weap.canUse(player))
			for (MinesweeperField ff : getMap().getIteration()) {
				if (weap.canUseAt(player, ff)) {
					list.add(player.createMove(weap, ff));
				}
			}
		}
		return list;
	}
	
	public List<WinChanceData> getMoves() {
		SortedSet<Entry<MinesweeperMove, WinChanceData>> mm = UtilZomisList.entriesSortedByValues(this.moves, true);
		List<WinChanceData> list = new ArrayList<WinChanceData>();
		for (Entry<MinesweeperMove, WinChanceData> ee : mm) {
			list.add(ee.getValue());
		}
		return list;
	}
	
	@Override
	public String toString() {
		return this.getMoves().toString();
	}
}
