package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class RandomAttackScorer extends AbstractScorer {

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsClick(scores.getWeapon());
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (ZomisTools.isZomisOpenField(field)) {
			for (MinesweeperField ff : field.getInvertedNeighbors()) {
				if (ff.isDiscoveredMine()) return 1;
			}
		}
		return 0;
	}

}
