package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.aiscore.*;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

// @AI(rating = -99999)
public class Disabled_AI_Horrible extends AI_Zomis {
	public Disabled_AI_Horrible() {
		super("#AI_DisabledHorrible", new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED)
			.withScorer(new MineProbability(), 1)
			.withScorer(new NonRevealingSafeClicks())
			.withScorer(new CertainMines())
			.withScorer(new OpenFieldsPenalty())
			.withScorer(new SafeProbabilityAroundMine())
			.withScorer(new SafeWithRiskAroundMineZomis())
			.withScorer(new SafeOpenField())
			.withScorer(new UnevenProbabilities())
			.withScorer(new AvoidReveal50_New())

			.withScorer(new BombScore())
			.withScorer(new BombIfManyMinesScorer(7.0 / 51.0))
			.multiplyAll(-1)
			.build());
	}
}
