package net.tejpbit.ais;

import java.util.Random;

import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

// @AI(rating = 500)
public class AI_Fighter extends MinesweeperAI {

	private final Random random = new Random();
    private final MinesweeperAI ai1 = new TejpbitAI_Hard();
    private final MinesweeperAI ai2 = new AI_Challenger();

	public AI_Fighter() {
		super("#AI_Fighter");
	}

	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return false;
	}

	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		if (random.nextBoolean()) {
            return ai1.play(pp);
        } else {
            return ai2.play(pp);
        }
	}

	@Override
	public boolean respondToInvite(Invite invite) {
		return true;
	}

}
