package net.zomis.minesweeper.analyze.utils;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;

public class ZomisTools {
	public static boolean isAIChallengerField(ProbabilityKnowledge<MinesweeperField> fieldData) {
		return !isZomisOpenField(fieldData.getField()) && fieldData.getMineProbability() > 0;
	}
	
	public static int fieldFoundMines(MinesweeperField field) {
		int i = 0;
		for (MinesweeperField ff : field.getNeighbors()) {
			if (ff.isDiscoveredMine()) i++;
		}
		return i;
	}
	public static int fieldNeedsMoreMines(MinesweeperField field) {
		if (!field.isClicked()) return 0;
		if (field.isDiscoveredMine()) return 0;
		return field.getKnownValue() - fieldFoundMines(field);
	}
	public static boolean isZomisOpenField(MinesweeperField field) {
		// If field has a neighbor that is clicked, it is not in open field group.
		for (MinesweeperField ff : field.getNeighbors()) {
			if (ff.isClicked() && !ff.isDiscoveredMine()) return false;
		}
		return true;
//		return this.analyze.getKnowledgeFor(field).getFieldGroup().size() > 8;
	}

}
