package net.zomis.minesweeper.ais.otherscorers;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class StaticScoreForWeapon extends AbstractScorer {

	private final String	weaponType;
	private final int	power;

	public StaticScoreForWeapon(String weaponType, int power) {
		this.weaponType = weaponType;
		this.power = power;
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return scores.getWeapon().getWeaponType().equals(this.weaponType);
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		return this.power;
	}

}
