package net.zomis.minesweeper.ais.mirror;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import net.zomis.minesweeper.ais.StatUtils;
import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.ScoreParameters;

public class MirrorDontTakeAll100 extends MirrorScorer {

	private AnalyzeProvider	rootAnalyze;
	private int	failed100 = 0;
	private int	taken100 = 0;

	private double	avoid;

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		this.rootAnalyze = AnalyzeFactory.analyze(scores.getPlayer().getMap(), false);
		double rand = random.nextDouble();
		double threshold = (double) failed100 / (double)(taken100 + failed100);
		if (rand <= threshold) {
			this.avoid = this.getAverage(this.rootAnalyze.getAnalyze());
		}
		else this.avoid = 100;
//		logger.error("random is " + rand + " to string is " + this.toString() + " making threshold " + threshold + " setting avoid to " + this.avoid);
		return this.weaponIsClick(scores.getWeapon());
	}

	private static Random random = new Random();
	
	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (this.failed100 + taken100 <= 0) return 0;
		
		FieldGroup<MinesweeperField> group = rootAnalyze.getAnalyze().getGroupFor(field);
		if (group == null) {
//			logger.error("group is null for " + field);
			return 0;
		}
		if (group.getProbability() > this.avoid) {
			return -1.5;
		}
		
		return 0;
	}

	private double getAverage(AnalyzeResult<MinesweeperField> analyze) {
		List<Double> probs = new ArrayList<Double>();
		for (FieldGroup<MinesweeperField> ff : analyze.getGroups()) {
			double prob = ff.getProbability();
			if (prob > 0.0 && prob < 0.9999) probs.add(prob);
		}
		if (probs.isEmpty()) probs.add(0.5);
		return StatUtils.mean(probs);
	}
	
	@Override
	public boolean moveInform(MinesweeperMove move, MinesweeperMap map) {
		AnalyzeProvider analyze = AnalyzeFactory.analyze(map, false);
		int find100 = 0;
//		find100 = MineprobHelper.find100(analyze.getAnalyze());
//		if (find100 == 0) return true;
		
		
		MinesweeperField field = map.getPosition(move.getField());
		FieldGroup<MinesweeperField> group = analyze.getAnalyze().getGroupFor(field);
		if (group == null) return true;
		
		double average = this.getAverage(analyze.getAnalyze());
//		logger.error("average is " + average + " your prob is " + group.getProbability());
		find100 = 1;
		if (group.getProbability() >= average) {
			this.taken100 += find100;
		}
		else this.failed100 += find100;
		
		return true;
	}

	@Override
	public double getPower() {
		return 1;
	}
	@Override
	public String toString() {
		return "Failed " + this.failed100 + " Taken " + this.taken100;
	}
}
