package net.zomis.minesweeper.ais;

import net.tejpbit.ais.TejpbitAI_Hard;
import net.zomis.minesweeper.aiscore.BombIfManyMinesScorer;
import net.zomis.minesweeper.aiscore.BombScore;
import net.zomis.minesweeper.aiscore.MineProbability;
import net.zomis.minesweeper.aiscore.OpenFieldProbability;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

// @AI(rating = 2100)
public class AI_HardPlus extends AI_Zomis {

	public AI_HardPlus() {
		super("#AI_HardPlus", new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED)
					.withScorer(new MineProbability(), 1)
					.withScorer(new OpenFieldProbability(), 0.0001)

					.withScorer(new BombScore())
					.withScorer(new BombIfManyMinesScorer(8.0 / 51.0))
					.build()
		);
		this.setBackup(new StaticAISupplier(new TejpbitAI_Hard()));
	}
	
	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		return playWithDrawproposal(pp);
	}
}
