package net.zomis.plugin;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;

@Deprecated
public class AutoMineprob extends MinesweeperPlugin implements EventListener {
	// @Event
	public void getMineProbabilityOfMove(PlayerMoveEvent event) {
		if (event.getPlayer().getGame() == null) return;
		
		AnalyzeProvider analyze = AnalyzeFactory.analyze(event.getMap(), true);
		
		MinesweeperField field = event.getMove().getMovePosition();
		ProbabilityKnowledge<MinesweeperField> group = analyze.getKnowledgeFor(field);
		String coord = "(" + field.getX() + ", " + field.getY() + ")";
		
		if (group != null) {
			event.getGame().sendChatMessage("#AI_Hard: Field " + coord + " has a mine probability of " + group.getMineProbability());
			double tot = 0;
			for (int i = 0; i <= group.getProbabilities().length; i++) {
				event.getGame().sendChatMessage("#AI_Extreme: Field " + coord + " has " + group.getProbabilities()[i] + " probability of being " + i);
				tot += group.getProbabilities()[i];
			}
			if (Math.abs(tot - 1.0) >= 0.001) event.getGame().sendChatMessage("Incorrect probability sum: " + tot, 0xFFFF0000);
		}
		else {
			event.getGame().sendChatMessage("#AI_Hard: Error: Field " + coord + " has an unknown mine probability.");
		}
	}
	
	@Command(command = "losertest", help = "")
	public void activate(PlayerCommandEvent event) {
		Invite invt = event.getPlayer().getServer().getPlayerByName("#AI_Loser").createInvitation(new String[]{ "AutoMineprob" });
		invt.sendInvite(event.getPlayer().getServer().getPlayerByName("#AI_Loser"));
		invt.startGame();
	}
	
	@Override
	public boolean canBeChosenBy(MinesweeperPlayer player) {
		return player.hasPermission(PlayerCommandEvent.PERMISSION_ADMIN);
	}

	@Override
	public void onDisable() {
		
	}

	@Override
	public void onEnable() {
//		this.registerListener(new DefaultExpanderRule());
//		this.registerListener(new StandardNeighbors());
//		this.registerListener(new StandardWeapons());
//		this.registerListener(this);
	}

}
