package net.zomis.minesweeper.ais;

import net.tejpbit.ais.TejpbitAI_Hard;
import net.zomis.minesweeper.aiscore.*;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

// @AI(rating = 2500)
public class AI_Extreme3 extends AI_Zomis {
	public AI_Extreme3() {
		super("#AI_Extreme3", new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED)
			.withScorer(new MineProbability(), 1)
			.withScorer(new NonRevealingSafeClicks())
			.withScorer(new CertainMines())
			.withScorer(new OpenFieldsPenalty())
			.withScorer(new SafeProbabilityAroundMine())
			.withScorer(new SafeWithRiskAroundMineZomis())
			.withScorer(new SafeOpenField())
			.withScorer(new UnevenProbabilities())
			.withScorer(new AvoidReveal50_New())

			.withScorer(new BombScore())
			.withScorer(new BombIfManyMinesScorer(8.0 / 51.0))
			.build());
		this.setBackup(new StaticAISupplier(new TejpbitAI_Hard()));
	}
	
	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		return this.playWithDrawproposal(pp);
	}
}
