package net.zomis.plugin;

import net.zomis.mario.classes.Board;
import net.zomis.mario.mfeais.AbstractMarioBot;
import net.zomis.mario.mfeais.Slow_AI_Mario_A2;
import net.zomis.mfe.plugin.ThreadInterruptCheck;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;

public class ProbabilityZomisVsMario extends MinesweeperPlugin implements EventListener {
	
	@Command(command = "probtest", help = "Test AI analyze code by Zomis vs. analyze by Mario", requiredPermission = PlayerCommandEvent.PERMISSION_ADMIN)
	public void testZomisMario(PlayerCommandEvent event) {
		MinesweeperGame game = event.getGame();
		
		long time;
		MinesweeperPlayer sendPlayer;
		
		// Zomis code
		sendPlayer = event.getServer().getPlayerByName("#AI_Hard");
		time = getTime();
		AnalyzeResult<MinesweeperField> analyze = new MineprobabilityAnalyze(game).solve();
		
		// perform "deepSolve" --> analyze detailed probabilities (and preferably, also payoffs and expected value) --> create extra field-groups for all unknown fields?
		// splitting fieldgroups will probably take a while, but then it will be hopefully highly efficient.
		time = getTime() - time;
		// get result
		
//		for (FieldGroup<MinesweeperField> grp : analyze.getGroups()) {
//			event.getPlayer().sendChatBy(grp + ": " + grp.getProbability(), sendPlayer);
//		}
		
		event.getPlayer().sendChatBy("Time spent: " + time, sendPlayer);
		long timeAIHard = time;
		
	 	// Mario code
		// was Old_AI_Mario_B
		sendPlayer = event.getServer().getPlayerByName("#" + Slow_AI_Mario_A2.class.getSimpleName());
		time = getTime();
		AbstractMarioBot aiMario = new Slow_AI_Mario_A2(new ThreadInterruptCheck(), game.getCurrentPlayer());
	 	aiMario.play(game.getCurrentPlayer()); // Perform analyze (also some minor overhead for changing data structure and returning the moves.
		time = getTime() - time;
		
		// get result
	 	Board marioBoard = aiMario.getBot().getBoard();
	 	double[][][] marioProbs = marioBoard.Probability();
	 	
	 	int breaks = 0;
	 	for (MinesweeperField ff : game.getIteration()) {
		 	if (marioProbs[ff.getY()][ff.getX()][9] > 0 || analyze.getGroupFor(ff) != null) {
		 		double diff = analyze.getGroupFor(ff).getProbability() - marioProbs[ff.getY()][ff.getX()][9];
		 		if (Math.abs(diff) > 0.00001) {
		 			breaks++;
                    double zomisProb = analyze.getGroupFor(ff).getProbability();
                    double marioProb = marioProbs[ff.getY()][ff.getX()][9];
		 			event.getPlayer().sendChatBy("DIFFERENCE! (" + ff.getX() + ", " + ff.getY() +"): " +
                        zomisProb + " vs. " + marioProb, sendPlayer, 0xFF0000);
		 		}
		 	}
	 	}
		event.getPlayer().sendChatBy("Total Mismatches: " + breaks, sendPlayer);
		long timeAIMario = time;
		
		event.getPlayer().sendChatBy("Time spent: " + time, sendPlayer);
	 	
		long diffTime = timeAIMario - timeAIHard;
		if (diffTime > 0) {
			event.getPlayer().sendChatBy("AI Hard wins by " + diffTime + " ms", event.getServer().getServerPlayer());
		}
		else {
			event.getPlayer().sendChatBy("Mario wins by " + diffTime + " ms", event.getServer().getServerPlayer());
		}
		
	}
	
	private long getTime() {
		return System.nanoTime();
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer arg0) {
		return false;
	}

	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
		this.registerListener(this);
	}
	
}
