package net.zomis.minesweeper.scores;

import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class PostScorer extends Scorer {
	public String getName() {
		return "Post-" + this.getClass().getSimpleName();
	}

	protected boolean weaponIsClick(MinesweeperWeapon weapon) {
		return weapon.getWeaponType().contentEquals(MinesweeperMove.STANDARD_CLICK);
	}
	protected boolean weaponIsBomb(MinesweeperWeapon weapon) {
		return weapon.getWeaponType().contentEquals(MinesweeperMove.STANDARD_BOMB);
	}

	public abstract void handle(FieldScores scores);
	
	protected void force(FieldScore fscore, double score) {
		if (fscore == null) throw new AssertionError();
		fscore.giveExtraScore(this, score);
	}
	protected void force(FieldScores scores, MinesweeperField field, double force) {
		FieldScore score = scores.getScores().get(field);
		this.force(score, force);
	}
	protected void forceSet(FieldScores scores, MinesweeperField field, double force) {
		FieldScore score = scores.getScores().get(field);
		if (score == null) throw new AssertionError();
		score.giveExtraScore(this, force - score.getScore());
	}
}
