package net.zomis.minesweeper.ais.test;

import java.util.Map;

import net.zomis.minesweeper.ais.AIZomisSupplier;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.api.ai.AISupplier;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.ScoreParameters;

public class AINormalizedScorer extends AbstractScorer {
	private AIZomisSupplier aiClass;
	private Map<MinesweeperField, FieldScore> scores;

	@Override
	public String getName() {
		return super.getName() + "-" + aiClass;
	}
	
	public AINormalizedScorer(AIZomisSupplier ai) {
		this.aiClass = ai;
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		MinesweeperPlayingPlayer player = scores.getPlayer();
		AI_Zomis instance = aiClass.get(player);
		FieldScores fscores = instance.createScoreProvider(player).analyzeAndScore(scores.getWeapon(), false);
		if (fscores == null) {
			this.scores = null;
			return false;
		}
		
		fscores.rankScores();
		this.scores = fscores.getScores();
		return true;
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		return this.scores.get(field).getNormalized();
	}

}
