package net.zomis.minesweeper.ais.otherscorers;

import java.util.List;

import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class NumRulesScorer extends AbstractScorer {

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return weaponIsClick(scores.getWeapon());
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		int i = 0;
		List<RuleConstraint<MinesweeperField>> rules = scores.getAnalyze().getAnalyze().getRules();
		for (RuleConstraint<MinesweeperField> rule : rules) {
            FieldRule<MinesweeperField> r = (FieldRule<MinesweeperField>) rule;
            for (FieldGroup<MinesweeperField> group : r.getFieldGroups()) {
				if (group.contains(field)) i++;
			}
		}
		return i;
	}

}
