package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.ais.otherscorers.Easy100Scorer;
import net.zomis.minesweeper.ais.otherscorers.NeighborsNeedsMoreMines;
import net.zomis.minesweeper.ais.otherscorers.RandomBomber;
import net.zomis.minesweeper.ais.otherscorers.RandomIdiotScorer;
import net.zomis.minesweeper.ais.otherscorers.StaticScoreForWeapon;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

// @AI(rating = -3200)
public class AI_Medium extends AI_Zomis {
	public AI_Medium() {
		super("#AI_Medium", new ScoreConfigFactory(AnalyzeMethod.NONE)
			.withScorer(new NeighborsNeedsMoreMines(), 0.3)
			.withScorer(new RandomIdiotScorer())
			.withScorer(new Easy100Scorer(), 10000)
			.withScorer(new RandomBomber(), 100)
			.withScorer(new StaticScoreForWeapon(MinesweeperMove.STANDARD_BOMB, -100))
			.build()
		);
	}
}
