package net.zomis.mfe.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import net.zomis.UtilZomisList;
import net.zomis.UtilZomisUtils;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;

public class TentaizuListener implements EventListener {

	private static interface TentaizuValidator {
		boolean isValid(MinesweeperField field, AnalyzeResult<MinesweeperField> before, AnalyzeResult<MinesweeperField> analyze);
	}
	private TentaizuValidator validOne = new TentaizuValidator() {
		@Override
		public boolean isValid(MinesweeperField field, AnalyzeResult<MinesweeperField> before, AnalyzeResult<MinesweeperField> analyze) {
			return analyze.getTotal() <= before.getTotal();
		}
	};
	private class TentaizuValidatorWithX implements TentaizuValidator {
		private final int	maxCombinations;
		private final int	desired100;

		public TentaizuValidatorWithX(int maxCombinations, int desired100) {
			this.maxCombinations = maxCombinations;
			this.desired100 = desired100;
		}

		@Override
		public boolean isValid(MinesweeperField field, AnalyzeResult<MinesweeperField> before, AnalyzeResult<MinesweeperField> analyze) {
			return analyze.getTotal() <= this.maxCombinations && MineprobHelper.find100(analyze) >= desired100;
		}
	}
	
	@Command(command = "tentaizu", help = "Hide squares if possible without having too many solutions on the board", requiredPermission = PlayerCommandEvent.PERMISSION_ADMIN)
	public void tentaizu(PlayerCommandEvent event) {
		if (event.getGame() != null) {
			event.getPlayer().sendAlert("Believe it or not, but /tentaizu is one of the few commands who is everything-but-server-only.");
		}
		
		event.getPlayer().sendChat("Param: " + event.getParameter(0));
		if (event.getParameter(0).contentEquals("new")) {
			this.newTentaizu(event.getMap(), event.getPlayer());
			event.getPlayer().sendChat("Unclicked: " + event.getMap().getAllUnclickedFields().size());
		}
		else if (event.getParameter(0).contentEquals("full")) {
			this.newTentaizu(event.getMap(), event.getPlayer());
			event.getPlayer().sendChat("Unclicked: " + event.getMap().getAllUnclickedFields().size());
			this.tentaizu(256, event.getMap(), event.getPlayer(), validOne);
		}
		else if (event.getParameter(0).contentEquals("simple")) {
			this.tentaizuEasier(event.getMap(), event.getParameterInt(1, 1));
		}
		else if (event.getParameter(0).contentEquals("random")) {
			this.newTentaizu(event.getMap(), event.getPlayer());
			event.getPlayer().sendChat("Unclicked: " + event.getMap().getAllUnclickedFields().size());
			MinesweeperMap map = event.getMap();
			Random rand = new Random();
			
			this.tentaizu(map.getFieldHeight() * map.getFieldWidth(), map, event.getPlayer(), 
					new TentaizuValidatorWithX(event.getParameterInt(1, rand.nextInt(10) + 1), 
							event.getParameterInt(2, rand.nextInt(40) + 12)
						));
		}
		else {
			int count = event.getParameterInt(0, 1);
			this.tentaizu(count, event.getMap(), event.getPlayer(), validOne);
			event.getPlayer().sendChat(count + " iterations");
		}
	}

	private void tentaizuEasier(MinesweeperMap map, int count) {
		for (int i = 0; i < count; i++) {
			List<MinesweeperField> fields = new ArrayList<MinesweeperField>();
			for (MinesweeperField ff : map.getIteration()) {
				if (!ff.isClicked() && !ff.isMine()) {
					fields.add(ff);
				}
			}
			
			MinesweeperField field = UtilZomisList.getRandom(fields);
			if (field != null) field.activate();
		}
	}

	private void tentaizu(int count, MinesweeperMap map, MinesweeperPlayer player, TentaizuValidator validator) {
		for (int i = 0; i < count; i++) {
			boolean b = this.tentaizuStep(map, player, validator);
			if (!b) {
                count = i+1;
                break;
            }
		}
	}

	private boolean tentaizuStep(MinesweeperMap map, MinesweeperPlayer player, TentaizuValidator validator) {
		List<MinesweeperField> fields = new ArrayList<MinesweeperField>();
		
		AnalyzeResult<MinesweeperField> analyze = AnalyzeFactory.analyze(map, false).getAnalyze();
		for (MinesweeperField ff : map.getIteration()) {
			if (this.isRemovable(ff, analyze, validator)) fields.add(ff);
		}
		
		int removed = 0;
		while (true) {
			MinesweeperField ff = UtilZomisList.getRandom(fields);
			if (player != null) player.sendChat("Step " + ff + " of " + fields.size() + " possible");
			if (ff == null) break;
			if (!this.isRemovable(ff, AnalyzeFactory.analyze(map, false).getAnalyze(), validator)) break;
			fields.remove(ff);
			ff.inactivate();
			removed++;
		}
		return removed > 0;
	}

	private boolean isRemovable(MinesweeperField ff, AnalyzeResult<MinesweeperField> before, TentaizuValidator validator) {
		if (!ff.isClicked()) return false;
		
		ff.inactivate();
		AnalyzeResult<MinesweeperField> now = AnalyzeFactory.analyze(ff.getMap(), false).getAnalyze();
		boolean valid = validator.isValid(ff, before, now);
		ff.activate();
		return valid;
	}

	private void newTentaizu(MinesweeperMap map, MinesweeperPlayer asker) {
		for (MinesweeperField ff : map.getIteration()) {
			if (!ff.isMine()) {
				if (asker != null) asker.sendChat(ff.toString());
				ff.activate();
			}
		}
	}
}
