package net.zomis.mario.probability;

import net.zomis.mario.classes.*;

public final class HyperGeometricDistribution
{
	static final HyperGeometricDistribution instance = new HyperGeometricDistribution();

	public double[][][][] probability;
	public double[][] auxKD;
	public double[][] auxMinesK;

	boolean isInitialized;

	int maxO = Configuration.BasicConfig().DIMH * Configuration.BasicConfig().DIMV + 1;
	int maxM = Configuration.BasicConfig().MINES + 1;
	static final int maxD = 25 + 1;
	static final int maxk = maxD;

	private HyperGeometricDistribution() { }

	public void Initialize()
	{
		if (!isInitialized)
		{
			probability = new double[maxk][maxD][maxM][maxO];

			auxKD = new double[maxk][maxD];
			auxMinesK = new double[maxM][maxk];
			PreCalculateKD();
			PreCalculateMinesK();
			Calculate();
		}

		isInitialized = true;
	}

	public static HyperGeometricDistribution getInstance()
	{
		return instance;
	}

	public double getthis(int k, int D, int mines, int opensea)
	{
		return instance.probability[k][D][mines][opensea];
	}

	/*       
        public double this[int k, int D, double mines, int opensea]
        {
            get
            {
                int lowMines = (int)Math.Floor(mines);
                int topMines = (int)Math.Ceiling(mines);

                double probability = instance.probability[k, D, lowMines, opensea].GetValueOrDefault() + (mines - lowMines) * (instance.probability[k, D, topMines, opensea].GetValueOrDefault() - instance.probability[k, D, lowMines, opensea].GetValueOrDefault());

                return probability;
            }
        }
	 */

	void Calculate()
	{
		int opensea, mines, d, k;

		for (opensea = 0; opensea < maxO; opensea++)
		{
			for (mines = 0; mines <= opensea && mines < maxM; mines++)
			{
				for (d = 0; d < maxD && d <= opensea; d++)
				{
					for (k = 0; k <= d; k++)
					{
						probability[k][d][mines][opensea] = CalculateHypergeometricValue(k, d, mines, opensea);
					}
				}
			}
		}
	}

	void PreCalculateKD()
	{
		int k, d, i;
		double factorial;

		for (k = 0; k < maxk; k++)
		{
			for (d = k; d < maxD; d++)
			{
				factorial = 1;
				for (i = d - k + 1; i <= d; i++)
				{
					factorial *= i;
				}
				for (i = 2; i <= k; i++)
				{
					factorial /= i;
				}
				auxKD[k][d] = factorial;
			}
		}
	}

	void PreCalculateMinesK()
	{
		int mines, k, i;
		double factorial;

		for (mines = 0; mines < maxM; mines++)
		{
			for (k = 0; k < maxk && k <= mines; k++)
			{
				factorial = 1;
				for (i = mines - k + 1; i <= mines; i++)
				{
					factorial *= i;
				}
				auxMinesK[mines][k] = factorial;
			}
		}
	}

	double CalculateHypergeometricValue(int k, int d, int mines, int opensea)
	{
		int i;
		double factorial = auxKD[k][d] * auxMinesK[mines][k];

		for (i = opensea - d + 1; i <= opensea; i++)
		{
			factorial /= i;
		}

		for (i = opensea - d - mines + k + 1; i <= opensea - mines; i++)
		{
			factorial *= i;
		}

		return factorial;
	}

	@Override
	public String toString()
	{
		int opensea, mines, k, d;
		StringBuilder stringBuilder = new StringBuilder("HYPERGEOMETRIC DISTRIBUTION [mines,opensea]\r\n");

		for (opensea = 0; opensea < maxO; opensea++)
		{
			for (mines = 0; mines < maxM && mines <= opensea; mines++)
			{
				stringBuilder.append("[" + mines +"," + opensea + "]\r\n");
				for (k = 0; k < maxk && k <= mines; k++)
				{
					for (d = 0; d < maxD && d <= opensea; d++)
					{
                        double probString = probability[k][d][mines][opensea];
						stringBuilder.append("(" + d + "," + k + ") " + probString + "\t");
					}
					stringBuilder.append("\n");
				}
				stringBuilder.append("\n");
			}
		}

		return stringBuilder.toString();
	}
}
